"""Represents types of square on the board"""

import serge.common


class Square(serge.common.Loggable):
    """Represents a square on the board"""
    
    sprite = 'unknown'
    is_start = False
    is_goal = False
    can_traverse = False
    can_place = False
    is_occupied = False
    can_freeze = False
    is_frozen = False
    frozen_for = 0
    
    def __init__(self, idx=0):
        """Initialise the square"""
        self.addLogger()
        self.idx = idx
        
class Road(Square):
    """A passable part of the board"""
    sprite = 'road'
    can_traverse = True
    can_freeze = True
    
class Wall(Square):
    """An impassable part of the board"""
    sprite = 'wall'
    
class Surface(Wall):
    """An impassable part of the board that turrets can be mounted on"""
    sprite = 'surface'
    can_place = True
    
class Start(Road):
    """A place where enemies start from"""
    sprite = 'start'
    is_start = True

class NearStart(Road):
    """A place where enemies start from"""
    sprite = 'near-start'
    
class Goal(Road):
    """The tower that you are defending"""    
    sprite = 'goal'
    is_goal = True
    
class Ground(Road):
    """The ground - can have turrets and is a road"""    
    sprite = 'ground'
    can_place = True
